 <?php

use yii\widgets\LinkPager;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use app\models\User;

$this->title = 'Диалог с '.Html :: encode($who->username  ?? 'Гость'.$who->id);

?>
    
	<div class="feedback">Последний визит: <?php echo Yii::$app->formatter->asDate($who->online,'php:d.m.y H:i');?></div>
	<div class="bordered center">
    <?php foreach($emojihead as $emh): ?>
		<a href="javascript:void(0);" class="label" onclick="Emoji('<?php echo $emh['name'];?>');"><img src="/images/smiles/<?php echo $emh['img'];?>.gif"></a>
		<?php endforeach;?>
	</div>	
	
    <div class="center">
    <?php $form = ActiveForm::begin([
        'id' => 'comment-form',
        'layout' => 'horizontal',
        'fieldConfig' => [
            'template' => "{label}\n<div class=\"col-lg-12\">{input}</div>\n<div class=\"col-lg-12\">{error}</div>",
            'labelOptions' => ['class' => 'col-lg-1 control-label'],
        ],
        
    ]); ?>

        <?= $form->field($model, 'text')->textarea(['rows' => 3, 'class' => 'message-input form-control'])->label('') ?>
        
      
                <?= Html::submitButton('Отправить', ['class' => 'btn btn-success', 'name' => 'add-button']) ?>
				<a class="btn btn-success" onclick="EmojiPanel();"><i class="fa fa-smile-o"></i></a>
				
           <?php ActiveForm::end(); ?>
	</div>
	<br>
	<p class="bordered center emojy">
	

		<?php foreach($emoji as $em): ?>
		<a href="javascript:void(0);" class="label" onclick="Emoji('<?php echo $em['name'];?>');"><img src="/images/smiles/<?php echo $em['img'];?>.gif"></a>
		<?php endforeach;?>
	
	</p>
	
	
	
	
        <?php if($count == 0): ?>
	
            <p class="feedback">Нет сообщений</p>
        <?php endif;?>
        
<?php foreach($all as $res): ?>
            <div class="bordered">
			<?php echo User :: findUser($res['user']);?> 
			<?php if($res['user'] != Yii::$app->user->id): ?>
			<img src="/images/icons/reply.png" width="16" class="reply" style="cursor:pointer;" onclick="reply('<?php echo User :: findOne($res['user'])->username;?>');"> 
			<?php endif;?>
			<span style="float: right;"><font size="1" color="grey"><?php echo ($res['_read'] == 1 ? '[Не прочитано]' : '[Прочитано]'); ?> <?php echo $res['time'];?></font></span>
				<br>
			<p style="color: #9edcdb;font-size:100%;margin-left:25px;"><?php echo \app\models\active\Smile :: View($res['text']);?></p>
			
		</div>
        <?php endforeach; ?>
        
            </div>
        <div class="center">
            <?= LinkPager::widget(['pagination' => $pagination]) ?>
        </div>
<hr>


<?php
$script = <<< JS

	
	function Emoji(smile)
	{
		var text = $('.message-input').val();
		
		$('.message-input').val(text+' '+smile);
		$('.message-input').focus();
	}
	
	function EmojiPanel()
	{
		
		if ($(".emojy").is(":hidden")) {
            $(".emojy").fadeIn(500);
        } else {
            $(".emojy").fadeOut();
        }
		
		
	}
	
JS;

$this->registerJs($script, $this::POS_END);